// SPON Rangefinder v0.3.0 (Addon version)
//
// Copyright (C) 2007-8 Bil Bas (bil {dot} bagpuss [at] gmail {dot} com / Spooner)
// License: GNU Lesser General Public License, version 3 <http://www.gnu.org/licenses/>

#ifndef SPON_ADDON
#define SPON_ADDON
#endif

#ifndef SPON_SCRIPTS_RF_HPP
#define SPON_SCRIPTS_RF_HPP

#include "handles.hpp"

#define SPON_RF_LED_VALUE_FONT_SIZE 0.05
#define SPON_RF_LED_VALUE_HEIGHT 0.07
#define SPON_RF_LED_VALUE_WIDTH 0.1175
#define SPON_RF_LED_VALUE_BACKGROUND_COLOUR { 0, 1, 0, 0.3 }
#define SPON_RF_LED_VALUE_FONT "Bitstream"

#define SPON_RF_LED_ICON_HEIGHT 0.03
#define SPON_RF_LED_ICON_WIDTH (SPON_RF_LED_ICON_HEIGHT * 0.75)

#define SPON_RF_LED_COLOUR {0, 1, 0, 1}

#define SPON_RF_BAR_COLOUR {0, 0, 0, 1}
#define SPON_RF_BAR_HEIGHT 0.09

#define SPON_RF_LABEL_FONT_SIZE 0.07
#define SPON_RF_LABEL_FONT "TahomaB"
#define SPON_RF_LABEL_COLOUR { 0, 0, 0, 1 }
#define SPON_RF_LABEL_HEIGHT (SPON_RF_LABEL_FONT_SIZE * 1)

#define SPON_RF_MODE_WIDTH 0.14
#define SPON_RF_MODE_HEIGHT 0.17
#define SPON_RF_MODE_X (1 - SPON_RF_MODE_WIDTH)
#define SPON_RF_MODE_Y (1 - 0.09 - SPON_RF_MODE_HEIGHT)


class SPON_RF_overlay
{
	idd = SPON_RF_OVERLAY_IDD;
	
	movingEnable = 0;
	duration = 9999999;
	fadein = 0;
	fadeout = 0;
	name = "SPON Rangefinder Overlay";
	
	onLoad = "SPON_RF_display = _this select 0;";
	onUnload = "SPON_RF_display = displayNull;";
	
	class Value : SPON_rscLabel
	{
		style = ST_RIGHT;
		w = SPON_RF_LED_VALUE_WIDTH;
		text = "";
		font = SPON_RF_LED_VALUE_FONT;
		sizeEx = SPON_RF_LED_VALUE_FONT_SIZE;
		h = SPON_RF_LED_VALUE_HEIGHT;
		colorText[] = SPON_RF_LED_COLOUR;
	};
	
	class ValueTop : Value
	{
		y = (SPON_RF_BAR_HEIGHT - SPON_RF_LED_VALUE_HEIGHT) / 2;
	};
	
	class ValueBottom : Value
	{
		y = 1 - SPON_RF_BAR_HEIGHT + ((SPON_RF_BAR_HEIGHT - SPON_RF_LED_VALUE_HEIGHT) / 2);
	};
	
	class ValueBackground : SPON_rscBackground
	{
		idc = -1;
		x = 0.4;
		y = 1 - SPON_RF_LED_FONT_HEIGHT;
		w = SPON_RF_LED_VALUE_WIDTH;
		h = SPON_RF_LED_VALUE_HEIGHT;
		colorBackground[] = SPON_RF_LED_VALUE_BACKGROUND_COLOUR;
	};
	
	class ValueBackgroundTop : ValueBackground
	{
		y = (SPON_RF_BAR_HEIGHT - SPON_RF_LED_VALUE_HEIGHT) / 2;
	};
	
	class ValueBackgroundBottom : ValueBackground
	{
		y = 1 - SPON_RF_BAR_HEIGHT + ((SPON_RF_BAR_HEIGHT - SPON_RF_LED_VALUE_HEIGHT) / 2);
	};
	
	class Led : SPON_rscPicture
	{
		w = SPON_RF_LED_ICON_WIDTH;
		h = SPON_RF_LED_ICON_HEIGHT;
		colorText[] = { 1, 1, 1, 1 };
		text = SPON_RF_LED_OFF;
	};
	
	class Bar : SPON_rscBackground
	{
		h = SPON_RF_BAR_HEIGHT;
		x = 0.3;
		w = 0.4;
		colorBackground[] = SPON_RF_BAR_COLOUR;
	};
	
	class Label : SPON_rscLabel
	{
		style = ST_CENTER;
		font = SPON_RF_LABEL_FONT;
		sizeEx = SPON_RF_LED_VALUE_FONT_SIZE;
		h = SPON_RF_LABEL_HEIGHT;
		w = 0.2;
		colorText[] = SPON_RF_LABEL_COLOUR;
	};
	
	class labelTop : Label
	{
		y = SPON_RF_BAR_HEIGHT;
	};
	
	class LabelBottom : Label
	{
		y = 1 - SPON_RF_BAR_HEIGHT - SPON_RF_LABEL_HEIGHT;
	};

	class ControlsBackground
	{
		// Background bars, so LEDs show up.
		class TopBar : Bar
		{
			idc = SPON_RF_TOP_BAR_IDC;
			y = 0;
		};
		
		class BottomBar : Bar
		{
			idc = SPON_RF_BOTTOM_BAR_IDC;
			y = 1 - SPON_RF_BAR_HEIGHT;
		};
		
		class AzimuthValueBackground : ValueBackgroundTop
		{
			x = 0.45 - SPON_RF_LED_VALUE_WIDTH;
		};
		
		class ElevationValueBackground : ValueBackgroundTop
		{
			x = 0.55;
		};

		class RangeValueBackground : ValueBackgroundBottom
		{
			x = 0.5 - (SPON_RF_LED_VALUE_WIDTH / 2);
		};
		
		// Mode selection
		class ModeSelection : SPON_rscListBox
		{
			idc = SPON_RF_MODE_LIST_IDC;
			
			x = SPON_RF_MODE_X;
			y = SPON_RF_MODE_Y;
			w = SPON_RF_MODE_WIDTH;
			h = SPON_RF_MODE_HEIGHT;
			
			colorText[] = SPON_RF_LED_COLOUR;
			sizeEx = SPON_FONT_SIZE_SMALL;
		};
	};
	
	class Controls
	{
		// Top row of labels.
		class AzimuthLabel : LabelTop
		{
			idc = SPON_RF_AZIMUTH_LABEL_IDC;
			text = "AZ";
			x = 0.275;
		};
		
		class TargettingLabel : LabelTop
		{
			idc = SPON_RF_TARGETTING_LABEL_IDC;
			text = "XMT";
			x = 0.4;
		};

		class ElevationLabel : LabelTop
		{
			idc = SPON_RF_ELEVATION_LABEL_IDC;
			text = "EL";
			x = 0.525;
		};
		
		// Bottom row of labels.
		class HeatLabel : LabelBottom
		{
			idc = SPON_RF_HEAT_LABEL_IDC;
			text = "HOT";
			x = 0.25;
		};
		
		class RangeLabel : LabelBottom
		{
			idc = SPON_RF_RANGE_LABEL_IDC;
			text = "MLT";
			x = 0.4;
		};
		
		class BatteryLabel : LabelBottom
		{
			idc = SPON_RF_BATTERY_LABEL_IDC;
			text = "BAT";
			x = 0.55;
		};
		
		// Values.
		class AzimuthValue : ValueTop
		{
			idc = SPON_RF_AZIMUTH_IDC;
			x = 0.45 - SPON_RF_LED_VALUE_WIDTH;
		};
		
		class ElevationValue : ValueTop
		{
			idc = SPON_RF_ELEVATION_IDC;
			x = 0.55;
		};
		
		class RangeValue : ValueBottom
		{
			idc = SPON_RF_RANGE_IDC;
			x = 0.5 - (SPON_RF_LED_VALUE_WIDTH / 2);
		};
		
		// LEDs
		class LaserOnLed : Led
		{
			idc = SPON_RF_LASER_ON_IDC;
			x = 0.5 - (SPON_RF_LED_ICON_WIDTH / 2);
			y = (SPON_RF_BAR_HEIGHT - SPON_RF_LED_ICON_HEIGHT) / 2;
		};
		
		class BatteryLed : Led
		{
			idc = SPON_RF_BATTERY_ON_IDC;
			x = 0.66;
			y = 1 - SPON_RF_BAR_HEIGHT + ((SPON_RF_BAR_HEIGHT - SPON_RF_LED_ICON_HEIGHT) / 2);
		};
		
		class HotLed : Led
		{
			x = 0.34 - SPON_RF_LED_ICON_WIDTH;
			y = 1 - SPON_RF_BAR_HEIGHT + ((SPON_RF_BAR_HEIGHT - SPON_RF_LED_ICON_HEIGHT) / 2);
		};
	};
};

#endif
